<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["region"] ) ) {
			$lookupTableLinks["region"] = array();
		}
		if( !isset( $lookupTableLinks["region"]["candidate.region"] )) {
			$lookupTableLinks["region"]["candidate.region"] = array();
		}
		$lookupTableLinks["region"]["candidate.region"]["edit"] = array("table" => "candidate", "field" => "region", "page" => "edit");
		if( !isset( $lookupTableLinks["region"] ) ) {
			$lookupTableLinks["region"] = array();
		}
		if( !isset( $lookupTableLinks["region"]["electioncase.region"] )) {
			$lookupTableLinks["region"]["electioncase.region"] = array();
		}
		$lookupTableLinks["region"]["electioncase.region"]["edit"] = array("table" => "electioncase", "field" => "region", "page" => "edit");
		if( !isset( $lookupTableLinks["persons"] ) ) {
			$lookupTableLinks["persons"] = array();
		}
		if( !isset( $lookupTableLinks["persons"]["persons.sex"] )) {
			$lookupTableLinks["persons"]["persons.sex"] = array();
		}
		$lookupTableLinks["persons"]["persons.sex"]["edit"] = array("table" => "persons", "field" => "sex", "page" => "edit");
		if( !isset( $lookupTableLinks["persons"] ) ) {
			$lookupTableLinks["persons"] = array();
		}
		if( !isset( $lookupTableLinks["persons"]["persons.religion"] )) {
			$lookupTableLinks["persons"]["persons.religion"] = array();
		}
		$lookupTableLinks["persons"]["persons.religion"]["edit"] = array("table" => "persons", "field" => "religion", "page" => "edit");
		if( !isset( $lookupTableLinks["persons"] ) ) {
			$lookupTableLinks["persons"] = array();
		}
		if( !isset( $lookupTableLinks["persons"]["persons.religionRegister"] )) {
			$lookupTableLinks["persons"]["persons.religionRegister"] = array();
		}
		$lookupTableLinks["persons"]["persons.religionRegister"]["edit"] = array("table" => "persons", "field" => "religionRegister", "page" => "edit");
		if( !isset( $lookupTableLinks["region"] ) ) {
			$lookupTableLinks["region"] = array();
		}
		if( !isset( $lookupTableLinks["region"]["persons.region"] )) {
			$lookupTableLinks["region"]["persons.region"] = array();
		}
		$lookupTableLinks["region"]["persons.region"]["edit"] = array("table" => "persons", "field" => "region", "page" => "edit");
		if( !isset( $lookupTableLinks["electioncase"] ) ) {
			$lookupTableLinks["electioncase"] = array();
		}
		if( !isset( $lookupTableLinks["electioncase"]["persons.numRegion"] )) {
			$lookupTableLinks["electioncase"]["persons.numRegion"] = array();
		}
		$lookupTableLinks["electioncase"]["persons.numRegion"]["edit"] = array("table" => "persons", "field" => "numRegion", "page" => "edit");
		if( !isset( $lookupTableLinks["persons"] ) ) {
			$lookupTableLinks["persons"] = array();
		}
		if( !isset( $lookupTableLinks["persons"]["persons.address_city"] )) {
			$lookupTableLinks["persons"]["persons.address_city"] = array();
		}
		$lookupTableLinks["persons"]["persons.address_city"]["edit"] = array("table" => "persons", "field" => "address_city", "page" => "edit");
		if( !isset( $lookupTableLinks["persons"] ) ) {
			$lookupTableLinks["persons"] = array();
		}
		if( !isset( $lookupTableLinks["persons"]["persons.address_street"] )) {
			$lookupTableLinks["persons"]["persons.address_street"] = array();
		}
		$lookupTableLinks["persons"]["persons.address_street"]["edit"] = array("table" => "persons", "field" => "address_street", "page" => "edit");
		if( !isset( $lookupTableLinks["persons"] ) ) {
			$lookupTableLinks["persons"] = array();
		}
		if( !isset( $lookupTableLinks["persons"]["persons.address_build"] )) {
			$lookupTableLinks["persons"]["persons.address_build"] = array();
		}
		$lookupTableLinks["persons"]["persons.address_build"]["edit"] = array("table" => "persons", "field" => "address_build", "page" => "edit");
		if( !isset( $lookupTableLinks["persons"] ) ) {
			$lookupTableLinks["persons"] = array();
		}
		if( !isset( $lookupTableLinks["persons"]["persons.job"] )) {
			$lookupTableLinks["persons"]["persons.job"] = array();
		}
		$lookupTableLinks["persons"]["persons.job"]["edit"] = array("table" => "persons", "field" => "job", "page" => "edit");
		if( !isset( $lookupTableLinks["persons"] ) ) {
			$lookupTableLinks["persons"] = array();
		}
		if( !isset( $lookupTableLinks["persons"]["persons.wasit_name"] )) {
			$lookupTableLinks["persons"]["persons.wasit_name"] = array();
		}
		$lookupTableLinks["persons"]["persons.wasit_name"]["edit"] = array("table" => "persons", "field" => "wasit_name", "page" => "edit");
		if( !isset( $lookupTableLinks["teams"] ) ) {
			$lookupTableLinks["teams"] = array();
		}
		if( !isset( $lookupTableLinks["teams"]["persons.teamName"] )) {
			$lookupTableLinks["teams"]["persons.teamName"] = array();
		}
		$lookupTableLinks["teams"]["persons.teamName"]["edit"] = array("table" => "persons", "field" => "teamName", "page" => "edit");
		if( !isset( $lookupTableLinks["leaders"] ) ) {
			$lookupTableLinks["leaders"] = array();
		}
		if( !isset( $lookupTableLinks["leaders"]["persons.leaderName"] )) {
			$lookupTableLinks["leaders"]["persons.leaderName"] = array();
		}
		$lookupTableLinks["leaders"]["persons.leaderName"]["edit"] = array("table" => "persons", "field" => "leaderName", "page" => "edit");
		if( !isset( $lookupTableLinks["repairlist"] ) ) {
			$lookupTableLinks["repairlist"] = array();
		}
		if( !isset( $lookupTableLinks["repairlist"]["persons.repairList"] )) {
			$lookupTableLinks["repairlist"]["persons.repairList"] = array();
		}
		$lookupTableLinks["repairlist"]["persons.repairList"]["edit"] = array("table" => "persons", "field" => "repairList", "page" => "edit");
		if( !isset( $lookupTableLinks["services"] ) ) {
			$lookupTableLinks["services"] = array();
		}
		if( !isset( $lookupTableLinks["services"]["persons.serviceCode"] )) {
			$lookupTableLinks["services"]["persons.serviceCode"] = array();
		}
		$lookupTableLinks["services"]["persons.serviceCode"]["edit"] = array("table" => "persons", "field" => "serviceCode", "page" => "edit");
		if( !isset( $lookupTableLinks["region"] ) ) {
			$lookupTableLinks["region"] = array();
		}
		if( !isset( $lookupTableLinks["region"]["religion_info.region"] )) {
			$lookupTableLinks["region"]["religion_info.region"] = array();
		}
		$lookupTableLinks["region"]["religion_info.region"]["edit"] = array("table" => "religion_info", "field" => "region", "page" => "edit");
		if( !isset( $lookupTableLinks["electioncase"] ) ) {
			$lookupTableLinks["electioncase"] = array();
		}
		if( !isset( $lookupTableLinks["electioncase"]["religion_info.numRegion"] )) {
			$lookupTableLinks["electioncase"]["religion_info.numRegion"] = array();
		}
		$lookupTableLinks["electioncase"]["religion_info.numRegion"]["edit"] = array("table" => "religion_info", "field" => "numRegion", "page" => "edit");
		if( !isset( $lookupTableLinks["persons"] ) ) {
			$lookupTableLinks["persons"] = array();
		}
		if( !isset( $lookupTableLinks["persons"]["religion_info.sex"] )) {
			$lookupTableLinks["persons"]["religion_info.sex"] = array();
		}
		$lookupTableLinks["persons"]["religion_info.sex"]["edit"] = array("table" => "religion_info", "field" => "sex", "page" => "edit");
		if( !isset( $lookupTableLinks["persons"] ) ) {
			$lookupTableLinks["persons"] = array();
		}
		if( !isset( $lookupTableLinks["persons"]["religion_info.religion"] )) {
			$lookupTableLinks["persons"]["religion_info.religion"] = array();
		}
		$lookupTableLinks["persons"]["religion_info.religion"]["edit"] = array("table" => "religion_info", "field" => "religion", "page" => "edit");
		if( !isset( $lookupTableLinks["persons"] ) ) {
			$lookupTableLinks["persons"] = array();
		}
		if( !isset( $lookupTableLinks["persons"]["religion_info.religionRegister"] )) {
			$lookupTableLinks["persons"]["religion_info.religionRegister"] = array();
		}
		$lookupTableLinks["persons"]["religion_info.religionRegister"]["edit"] = array("table" => "religion_info", "field" => "religionRegister", "page" => "edit");
		if( !isset( $lookupTableLinks["region"] ) ) {
			$lookupTableLinks["region"] = array();
		}
		if( !isset( $lookupTableLinks["region"]["statistics_case.region"] )) {
			$lookupTableLinks["region"]["statistics_case.region"] = array();
		}
		$lookupTableLinks["region"]["statistics_case.region"]["edit"] = array("table" => "statistics_case", "field" => "region", "page" => "edit");
		if( !isset( $lookupTableLinks["electioncase"] ) ) {
			$lookupTableLinks["electioncase"] = array();
		}
		if( !isset( $lookupTableLinks["electioncase"]["statistics_case.numCase"] )) {
			$lookupTableLinks["electioncase"]["statistics_case.numCase"] = array();
		}
		$lookupTableLinks["electioncase"]["statistics_case.numCase"]["edit"] = array("table" => "statistics_case", "field" => "numCase", "page" => "edit");
		if( !isset( $lookupTableLinks["region"] ) ) {
			$lookupTableLinks["region"] = array();
		}
		if( !isset( $lookupTableLinks["region"]["_________.region"] )) {
			$lookupTableLinks["region"]["_________.region"] = array();
		}
		$lookupTableLinks["region"]["_________.region"]["search"] = array("table" => "حسب القلم", "field" => "region", "page" => "search");
		if( !isset( $lookupTableLinks["electioncase"] ) ) {
			$lookupTableLinks["electioncase"] = array();
		}
		if( !isset( $lookupTableLinks["electioncase"]["_________.numCase"] )) {
			$lookupTableLinks["electioncase"]["_________.numCase"] = array();
		}
		$lookupTableLinks["electioncase"]["_________.numCase"]["search"] = array("table" => "حسب القلم", "field" => "numCase", "page" => "search");
		if( !isset( $lookupTableLinks["region"] ) ) {
			$lookupTableLinks["region"] = array();
		}
		if( !isset( $lookupTableLinks["region"]["_________________.name"] )) {
			$lookupTableLinks["region"]["_________________.name"] = array();
		}
		$lookupTableLinks["region"]["_________________.name"]["search"] = array("table" => "دائري حسب المنطقة", "field" => "name", "page" => "search");
		if( !isset( $lookupTableLinks["region"] ) ) {
			$lookupTableLinks["region"] = array();
		}
		if( !isset( $lookupTableLinks["region"]["_______________.region"] )) {
			$lookupTableLinks["region"]["_______________.region"] = array();
		}
		$lookupTableLinks["region"]["_______________.region"]["search"] = array("table" => "دائري حسب القلم", "field" => "region", "page" => "search");
		if( !isset( $lookupTableLinks["electioncase"] ) ) {
			$lookupTableLinks["electioncase"] = array();
		}
		if( !isset( $lookupTableLinks["electioncase"]["_______________.numCase"] )) {
			$lookupTableLinks["electioncase"]["_______________.numCase"] = array();
		}
		$lookupTableLinks["electioncase"]["_______________.numCase"]["search"] = array("table" => "دائري حسب القلم", "field" => "numCase", "page" => "search");
}

?>